//
//  MCReportChooseReportTemplate.h
//  MCReporting
//
//  Created by Alykhan Jetha on 05/03/06.
//  Copyright 2006 Marketcircle Inc.. All rights reserved.
//

#import <MCApplication/MCWindowController.h>
#import <MCApplication/MCMainWindowController.h>

@class MCSplitView;
@class MCReportWhiteBox;
@class MCScalingScrollView;
@class MCReportWrapper;
@class MCReportUserInputView;
@class MCReportCenteringScrollView;


@interface MCMainWindowController (MCReportRunReports)
- (IBAction)runReports:(id)sender;
@end


@interface MCReportChooseReportTemplate : MCWindowController 
{

	int currentPageCount;
	BOOL shouldAutorelease;
	
	IBOutlet MCSplitView *splitView;
	IBOutlet NSTableView *sourceList;
	IBOutlet NSTabView *tabView;
	IBOutlet MCReportWhiteBox *whiteBox;
	IBOutlet NSProgressIndicator *wheelIndicator; // we don't use super's because that's a bar
	IBOutlet NSTextField *selectField;
	IBOutlet MCScalingScrollView *scalingScrollView;
	IBOutlet MCReportCenteringScrollView *userInputScrollView;
	
	IBOutlet NSOutlineView *outlineView;
	
	IBOutlet NSButton *backButton;
	IBOutlet NSButton *generateThenPrintButton;
	
	MCReportWrapper *selectedReport;
	
	NSArray *reportWrappers;

	
	NSDocument *referringDocument;  // weak ref
	NSWindow *referringWindow; // weak ref
	
	NSMutableArray *expandedItems;

}

+ (void)runChooseReportTemplateForDocument:(NSDocument *)aDoc 
								  inWindow:(NSWindow *)aWindow;

- (void)loadTemplates;

- (BOOL)shouldAutorelease;
- (void)setShouldAutorelease:(BOOL)flag;

- (NSDocument *)referringDocument;
- (void)setReferringDocument:(NSDocument *)aReferringDocument;

- (NSWindow *)referringWindow;
- (void)setReferringWindow:(NSWindow *)aReferringWindow;

- (NSArray *)reportWrappers;
- (void)setReportWrappers:(NSArray *)aReportWrappers;
- (MCReportWrapper *)lastReportWithUserInput;

- (MCReportWrapper *)selectedReport;
- (void)setSelectedReport:(MCReportWrapper *)aSelectedReport;

- (id)selectedObjectInOutline;

- (void)ensureStartViewInPlace;
- (void)ensureCriteriaViewInPlace;
- (void)ensureProgressViewInPlace;
- (void)ensurePreviewViewInPlace;



- (IBAction)cancel:(id)sender;
- (IBAction)generateThenPrint:(id)sender;
- (IBAction)backToCriteria:(id)sender;

- (IBAction)editReport:(id)sender;
- (IBAction)reloadTemplates:(id)sender;


- (void)generateReport:(MCReportWrapper *)aReport;

@end
